package gov.va.med.mhv.admin.repository;

import gov.va.med.mhv.admin.model.UserAcceptTermsHist;

import java.util.Date;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface UserAcceptTermsHistRepository extends JpaRepository<UserAcceptTermsHist, Long> {

	@Query("Select u from UserAcceptTermsHist u where u.userProfileId=:userProfileId and u.userUpdatedTime= :userUpdatedTime")
	List<UserAcceptTermsHist> getUserAcceptTermsHistByUpdateTime(@Param("userProfileId") Long userProfileId,
			@Param("userUpdatedTime") Date userUpdatedTime);

	@Query("Select u from UserAcceptTermsHist u where u.userProfileId=:userProfileId order by u.userUpdatedTime desc")
	List<UserAcceptTermsHist> getUserAcceptTermsHistByUserProfileId(@Param("userProfileId") Long userProfileId);

	@Modifying
	@Transactional
	@Query("delete from UserAcceptTermsHist u where u.userProfileId= :userProfileId")
	void deleteByUserProfileId(@Param("userProfileId") Long userProfileId);
}
